/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.ModLoot;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class OriginLootCondition
implements ILootCondition {
    private final ResourceLocation origin;

    private OriginLootCondition(ResourceLocation origin) {
        this.origin = origin;
    }

    public LootConditionType func_230419_b_() {
        return ModLoot.ORIGIN_LOOT_CONDITION;
    }

    public boolean test(LootContext lootContext) {
        Optional<OriginComponent> optional = ModComponentsArchitectury.maybeGetOriginComponent((Entity)lootContext.func_216031_c(LootParameters.field_216281_a));
        if (optional.isPresent()) {
            OriginComponent component = optional.get();
            HashMap<OriginLayer, Origin> map = component.getOrigins();
            boolean matches = false;
            for (Map.Entry<OriginLayer, Origin> entry : map.entrySet()) {
                if (!entry.getValue().getIdentifier().equals((Object)this.origin)) continue;
                matches = true;
                break;
            }
            return matches;
        }
        return false;
    }

    public static ILootCondition.IBuilder builder(String originId) {
        return OriginLootCondition.builder(new ResourceLocation(originId));
    }

    public static ILootCondition.IBuilder builder(ResourceLocation origin) {
        return () -> new OriginLootCondition(origin);
    }

    public static class Serializer
    implements ILootSerializer<OriginLootCondition> {
        public void toJson(JsonObject jsonObject, OriginLootCondition originLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("origin", originLootCondition.origin.toString());
        }

        public OriginLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new OriginLootCondition(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"origin")));
        }
    }
}

